import cdk = require('@aws-cdk/core');
import app = require('./portal-app/portal-app');
import cm = require('./capacity-management/capacity-management');

export interface StackProps {
  cdkProps: cdk.StackProps;
  portalAppProps: app.PortalAppProps;
}

export class PortalAppStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: StackProps) {
    super(scope, id, props.cdkProps);

    new app.PortalApp(this, 'PortalApp', props.portalAppProps);

    // Capacity management constructs from here https://git-aws.internal.justin.tv/coleiain/capacity-cdk but pulled in directly for now
    // Once CDK is stable I should probably add this to NPM
    new cm.CapacityCdk(this, "TwitchCapacityManagementRoles")
  }
}
