package main

import (
	twirpLambda "code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	ccc "code.justin.tv/event-engineering/carrot-control/pkg/client"
	cc "code.justin.tv/event-engineering/carrot-control/pkg/rpc"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/lambda"
)

func generateLambdaCCClient(sess *session.Session, lambdaARN string, carrotControlClientID string) cc.CarrotControl {
	lambdaClient := lambda.New(sess)
	lambdaTransport := twirpLambda.NewClient(lambdaClient, lambdaARN)

	ccClient := ccc.New(carrotControlClientID, lambdaTransport)
	return cc.NewCarrotControlProtobufClient("https://would.you.like.a.carrot.twitch.tv", ccClient)
}
