import * as React from 'react';
import { BrowserRouter as Router, Route, Switch } from 'react-router-dom';
import { AppContextProvider, AppContextRoot } from 'common/appcontext';
import { NavBar } from 'components/nav-bar';
import { SideBar } from 'components/side-bar';
import { API } from 'lib/api';
import { ChannelViewerPage } from 'modules/channelviewer';
import { HealthPage } from 'modules/health';
import { HomePage } from 'modules/home';
import { ReportsPage } from 'modules/reports';
import { SessionviewerPage } from 'modules/sessionviewer';
import { VideoAnalysisPage } from 'modules/videoanalysis';
import { AccountViewerPage } from 'modules/accountviewer';

import './App.css';
import "twitch-core-ui/css/index-light.css";

// We bring in all Core-UI exports to make consuming them straight forward for all audiences.
// @ts-ignore
import { Align, AlignContent, AlignItems, AlignSelf, Animation, AnimationDelay, AnimationDuration, AnimationFillMode, AnimationTiming, AnimationType, Aspect, AspectRatio, Avatar, AvatarSize, Background, Badge, BadgeType, Balloon, BalloonDirection, BalloonSize, BorderRadius, BoxArtCard, Button, ButtonIcon, ButtonIconType, ButtonSize, ButtonState, ButtonType, Card, CardBody, CardImage, CardImageSize, ChannelStatusIndicator, ChannelStatusIndicatorSize, ChannelStatusIndicatorStatus, CheckBox, Color, Column, CoreImage, CoreImageSize, CoreLink, CoreLinkType, CoreSrcSet, CoreText, Display, DropZone, FlexDirection, FlexWrap, FontSize, FormGroup, FormGroupOrientation, getDataProps, Grid, GridGutterSize, InjectLayout, InjectStyledLayout, Input, InputType, Interactable, JustifyContent, Layout, LineHeight, LoadingSpinner, Overflow, Pagination, PaginationControl, PaginationControlType, PaginationIndex, PaginationMouseEvent, Pill, PillType, Placeholder, Position, Presence, PresenceStatus, ProgressBar, ProgressBarSize, ProgressBarStatus, Radio, Range, Resize, ResponsiveWrapper, SearchInput, SegmentedButton, SegmentedButtonOption, Select, Sorting, SpinnerSize, Stat, StyledLayout, SVG, SVGAsset, SVGType, Tab, Table, TableBody, TableCell, TableHeader, TableHeading, TableRow, TabWrapper, Tag, TextAlign, TextArea, TextDecoration, TextTransform, TextType, ThumbnailCard, Toast, Toggle, Tooltip, TooltipAlign, TooltipDirection, Tower, TowerChildWidth, TowerGutter, Typeset, VerticalAlign, Visibility, WordBreak, ZIndex } from 'twitch-core-ui';

const kc = [38, 38, 40, 40, 37, 39, 37, 39, 66, 65];
const kcClass = 'these-are-not-the-droids-youre-looking-for';

export interface State {
  userInfo: UserInfo | null;
}

export class App extends React.Component<{}, State> {

  private kb: number[] = [];
  private appClass: string = '';

  constructor(props: {}, state: State) {
    super(props, state);

    this.state = {
      userInfo: null,
    };
  }

  public render() {
    return (
      <AppContextProvider>
        <Router>
          <Layout fullHeight display={Display.Flex} flexDirection={FlexDirection.Column} flexWrap={FlexWrap.Wrap}>
            <Layout fullWidth zIndex={ZIndex.Above} position={Position.Relative}>
              <NavBar userInfo={this.state.userInfo} />
            </Layout>
            <Layout fullWidth flexGrow={1} position={Position.Relative}>
              <Layout fullHeight fullWidth position={Position.Absolute}>
                <Grid fullHeight>
                  <Column cols={{ default: 4, xs: 3, sm: 3, md: 2, lg: 2, xl: 2, xxl: 1 }}>
                    <SideBar userInfo={this.state.userInfo} />
                  </Column>
                  <Column cols={{ default: 8, xs: 9, sm: 9, md: 10, lg: 10, xl: 10, xxl: 11 }}>
                    <Layout fullHeight>
                      <Switch>
                        <Route exact path="/" component={HomePage} />
                        <Route path="/sessionviewer" component={SessionviewerPage} />
                        <Route path="/channelviewer" component={ChannelViewerPage} />
                        <Route path="/account" component={AccountViewerPage} />
                        <Route path="/reports" component={ReportsPage} />
                        <Route path="/health" component={HealthPage} />
                        <Route path="/videoanalysis" component={VideoAnalysisPage} />
                      </Switch>
                    </Layout>
                  </Column>
                </Grid>
              </Layout>
            </Layout>
          </Layout>
        </Router>
        <AppContextRoot />
      </AppContextProvider>
    );
  }

  public componentDidMount() {
    document.addEventListener('keydown', this.onKeyDown);
  }

  public componentWillUnmount() {
    document.removeEventListener('keydown', this.onKeyDown);
  }

  public componentWillMount() {
    this.getUserUnfo();
  }

  private onKeyDown = (ev: KeyboardEvent) => {
    this.kb.push(ev.keyCode);
    if (this.kb.length > kc.length) {
      this.kb.splice(0, this.kb.length - kc.length);
    }

    if (JSON.stringify(this.kb) === JSON.stringify(kc)) {
      const wrapper = document.querySelector('#root');
      if (!wrapper) {
        return;
      }

      if (this.appClass === kcClass) {
        wrapper.classList.remove(this.appClass);
        this.appClass = '';
      } else {
        this.appClass = kcClass;
        wrapper.classList.add(this.appClass);
      }

      this.kb = [];
    }
  }

  private async getUserUnfo() {
    const userInfo = await getUserInfo();
    this.setState({ userInfo });
  }
}

export interface UserInfo {
  login: string;
  permissions: Permissions;
  timezones: Timezone[];
}

export interface Timezone {
  name: string
  offset: string
  offset_minutes: number
}

export interface Permissions {
  can_access_system: boolean;
  can_access_tools: boolean;
  can_access_twitch_data: boolean;
}

export async function getUserInfo(): Promise<UserInfo | null> {
  const path = `/api/auth/info`;

  const response = await API.get<UserInfo>(path, {});
  if (response.body === undefined) {
    return null;
  }

  return response.body;
}
