import * as React from 'react';
import { ButtonProps } from 'twitch-core-ui';

export interface ModalProps {
  title?: string;
  primaryButtonProps?: ButtonProps;
  secondaryButtonProps?: ButtonProps;
  onClose?: () => {};
}

export interface AppContextProps {
  modalProps: ModalProps;
}

export const AppContext = React.createContext({
  props: {} as AppContextProps,
  modalContent: null as React.ReactNode,
  showModal: (_: React.ReactNode, __: ModalProps) => { },
  hideModal: () => {},
  timezoneOffset: undefined,
  setTimezone: (offset: number) => {},
  getTimezoneOffset: () :number | undefined => { return 0 }
});
