import * as React from 'react';
import { Background, Color, Display, JustifyContent, Layout, Modal, ModalBody, ModalFooter, ModalHeader, ModalSize, Position, StyledLayout, ZIndex } from 'twitch-core-ui';
import { AppContext } from './appcontext';

export class AppContextRoot extends React.Component {
  public render() {
    return (
      <AppContext.Consumer>
        {({ modalContent: ModalContent, props }) =>
          ModalContent ? (
            <StyledLayout
              position={Position.Fixed}
              fullHeight
              fullWidth
              zIndex={ZIndex.Above}
              attachTop
              background={Background.Overlay}
              color={Color.Base}
              justifyContent={JustifyContent.Center}
              display={Display.Flex}
            >
              <Layout padding={{ top: 5 }}>
                <Modal size={ModalSize.Medium} elevation={3}>
                  <ModalHeader
                    title={props.modalProps.title ? props.modalProps.title : ''}
                    closeButton={{
                      "aria-label": 'Close',
                      onClick: props.modalProps.onClose,
                    }}
                  />
                  <ModalBody>
                    <Layout padding={2}>
                      {ModalContent}
                    </Layout>
                  </ModalBody>
                  {props.modalProps.primaryButtonProps &&
                    <ModalFooter
                      primaryButtonProps={props.modalProps.primaryButtonProps}
                      secondaryButtonProps={props.modalProps.secondaryButtonProps}
                    />
                  }
                </Modal>
              </Layout>
            </StyledLayout>
          ) : null}
      </AppContext.Consumer>
    );
  }
}
