import * as React from 'react';
import { InjectLayout } from 'twitch-core-ui';

export interface Props {
  onCanvasReady: (ref: HTMLCanvasElement) => void;
}

export class HighDPICanvas extends React.Component<Props, {}> {
  public render() {
    return (
      <InjectLayout fullWidth>
        <canvas ref={this.handleCanvasReady} />
      </InjectLayout>
    );
  }

  private handleCanvasReady = (ref: HTMLCanvasElement) => {
    if (!ref) {
      return;
    }

    this.setCanvasResolution(ref);
    this.props.onCanvasReady(ref);
  }

  private setCanvasResolution(ref: HTMLCanvasElement) {
    const { width, height } = ref;
    const ratio = this.getPixelRatio(ref.getContext('2d'));
    ref.width = width * ratio;
    ref.height = height * ratio;
    ref.style.width = `${width}px`;
    ref.style.height = `${height}px`;
    ref.getContext('2d')!.setTransform(ratio, 0, 0, ratio, 0, 0);
  }

  /**
   *  Calculate devicePixelRatio for canvas: https://stackoverflow.com/questions/15661339/how-do-i-fix-blurry-text-in-my-html5-canvas#15666143
   */
  // tslint:disable-next-line:no-any
  private getPixelRatio(context: any) {
    const dpr = window.devicePixelRatio || 1;
    const bsr =
      context.webkitBackingStorePixelRatio ||
      context.mozBackingStorePixelRatio ||
      context.msBackingStorePixelRatio ||
      context.oBackingStorePixelRatio ||
      context.backingStorePixelRatio ||
      1;

    return dpr / bsr;
  }
}
