import { API } from 'lib/api';
import { SECEvent } from 'common/sec/model'

export interface ListLimitBreachEventsResponse {
  limit_breach_events: SECEvent[];
  next_page_token: string
}

export async function getLimitBreaches(customerID: string, region: string, sessionID: string, pageToken: string): Promise<ListLimitBreachEventsResponse> {
  let path = `/api/limit_breaches/` + customerID + '/' + region;

  let qs = [];

  if (pageToken) {
    qs.push('page_token=' + encodeURIComponent(pageToken))
  }

  if (sessionID) {
    qs.push('session_id=' + encodeURIComponent(sessionID))
  }

  if (qs.length > 0) {
    path += '?' + qs.join('&')
  }

  const response = await API.get<ListLimitBreachEventsResponse>(path, {});

  if (response.error) {
    response.error.status = response.status
    return Promise.reject(response.error);
  }

  if (response.body === undefined) {
    return undefined;
  }

  return response.body;
}
