import * as Cookies from 'js-cookie';
import * as React from 'react';
import { ACCESS_TOKEN_COOKIE_NAME } from 'lib/api';
// @ts-ignore
import { AlignItems, Background, Color, Display, FlexDirection, JustifyContent, Layout, StyledLayout, SVG, SVGAsset, ZIndex } from 'twitch-core-ui';
import { UserInfo } from '../../App';
import './nav-bar.css';
// @ts-ignore
import { TimezoneSelector } from './timezone-selector';
import { UserMenuDropdown } from './user-menu-dropdown';

interface State {
  dropdownOpen: boolean;
}

interface Props {
    userInfo: UserInfo | null;
}

export class NavBar extends React.Component<Props, State> {
  constructor(props: Props, state: State) {
    super(props, state);

    this.state = {
      dropdownOpen: false,
    };
  }

  public render() {
      const ivsLogo = (
          <figure className="tw-svg ivs_logo">
              <svg
                  className="tw-svg__asset"
                  width={'32px'}
                  height={'32px'}
                  version="1.1"
                  viewBox={`0 0 50 50`}
                  x="0px"
                  y="0px"
              >
                  <g>
                      <path
                          d="M20,46.2c-0.2,0-0.3,0-0.5-0.1l-10-5.8C9.2,40.1,9,39.8,9,39.4s0.2-0.7,0.5-0.9L19,33V16.9l-9.5-5.5
              C9.2,11.2,9,10.9,9,10.6s0.2-0.7,0.5-0.9l10-5.8c0.3-0.2,0.7-0.2,1,0C20.8,4.1,21,4.4,21,4.8v11l14,8.1l9.5-5.5c0.3-0.2,0.7-0.2,1,0
              s0.5,0.5,0.5,0.9v11.5c0,0.4-0.2,0.7-0.5,0.9c-0.3,0.2-0.7,0.2-1,0L35,26.1l-14,8.1v11c0,0.4-0.2,0.7-0.5,0.9
              C20.3,46.2,20.2,46.2,20,46.2z M12,39.4l7,4v-8.1L12,39.4z M21,18.1V32l12-7L21,18.1z M37,25l7,4v-8L37,25z M12,10.6l7,4V6.5
              L12,10.6z M30,46.2c-0.2,0-0.3,0-0.5-0.1c-0.3-0.2-0.5-0.5-0.5-0.9V33.7c0-0.4,0.2-0.7,0.5-0.9s0.7-0.2,1,0l10,5.8
              c0.3,0.2,0.5,0.5,0.5,0.9s-0.2,0.7-0.5,0.9l-10,5.8C30.3,46.2,30.2,46.2,30,46.2z M31,35.4v8.1l7-4L31,35.4z M5,31.8
              c-0.2,0-0.3,0-0.5-0.1C4.2,31.5,4,31.1,4,30.8V19.2c0-0.4,0.2-0.7,0.5-0.9s0.7-0.2,1,0l10,5.8c0.3,0.2,0.5,0.5,0.5,0.9
              s-0.2,0.7-0.5,0.9l-10,5.8C5.3,31.7,5.2,31.8,5,31.8z M6,21v8l7-4L6,21z M30,17.3c-0.2,0-0.3,0-0.5-0.1C29.2,17,29,16.7,29,16.3V4.8
              c0-0.4,0.2-0.7,0.5-0.9c0.3-0.2,0.7-0.2,1,0l10,5.8c0.3,0.2,0.5,0.5,0.5,0.9s-0.2,0.7-0.5,0.9l-10,5.8C30.3,17.3,30.2,17.3,30,17.3z
               M31,6.5v8.1l7-4L31,6.5z"
                      />
                  </g>
              </svg>
          </figure>
      );

    return (
      <StyledLayout display={Display.Flex} alignItems={AlignItems.Center} zIndex={ZIndex.Above} justifyContent={JustifyContent.Between} background={Background.Accent} color={Color.Overlay}>
        <Layout flexGrow={0} flexShrink={0} padding={1}>
            {ivsLogo}
        </Layout>
        <Layout flexGrow={1} justifyContent={JustifyContent.End} display={Display.Flex} flexDirection={FlexDirection.Row}>
          <Layout margin={{ left: 2 }}>
            <TimezoneSelector userInfo={this.props.userInfo} />
          </Layout>
        </Layout>
        <UserMenuDropdown userInfo={this.props.userInfo} logout={this.logout} />
      </StyledLayout>
    );
  }

  private logout = () => {
    this.setState({
      dropdownOpen: false,
    });
    Cookies.remove(ACCESS_TOKEN_COOKIE_NAME);
  }
}
