import * as React from 'react';
import { FormGroup, Input, InputType } from 'twitch-core-ui';

interface Props {
  setValue: (text: number | undefined) => string | undefined;
  defaultValue?: number | undefined;
  label: string;
  helperText?: HTMLElement;
}

interface State {
  validationError?: string;
}

export class NumberInput extends React.Component<Props, State> {
  public state: State = {

  };

  constructor(props: Props, state: State) {
    super(props, state);
  }

  public render() {
    return (
      <FormGroup error={this.state.validationError !== undefined} errorMessage={this.state.validationError} label={this.props.label}>
        <Input type={InputType.Number} placeholder={this.props.label} onChange={this.onChange} value={this.numberToString(this.props.defaultValue)} />
      </FormGroup>
    );
  }

  private numberToString = (input: number | undefined): string | undefined => {
    if (input === undefined) {
      return undefined;
    }

    return input.toString();
  }

  private onChange = (event: React.FormEvent<HTMLInputElement>) => {
    let value: string | undefined = event.currentTarget.value;
    let intValue: number | undefined;

    if (value === '') {
      intValue = undefined;
    }

    intValue = parseInt(value, 10);

    if (isNaN(intValue)) {
      intValue = undefined;
    }

    this.setState({
      validationError: this.props.setValue(intValue),
    });
  }
}
