import * as React from 'react';
import { Layout } from 'twitch-core-ui';
import { ReactComponent as Hi } from "./hi.svg";
import { ReactComponent as NotFound } from "./not_found.svg";
import { ReactComponent as ResultFound } from "./result_found.svg";
import { ReactComponent as Thinking } from "./thinking.svg";

export enum Pose {
  Hi = 0,
  Thinking,
  ResultFound,
  NotFound
}

interface Props {
  pose: Pose
}

export class Carrot extends React.Component<Props, {}> {
  constructor(props: Props, state: {}) {
    super(props, state);
  }

  public render() {
    let icon = <Hi />;

    switch (this.props.pose) {
      case Pose.Hi:
        icon = <Hi />;
        break;
      case Pose.Thinking:
        icon = <Thinking />;
        break;
      case Pose.ResultFound:
        icon = <ResultFound />;
        break;
      case Pose.NotFound:
        icon = <NotFound />;
        break;
    }

    return (
      <Layout fullWidth>
        {icon}
      </Layout>
    );
  }
}
