import * as React from 'react';
import { Layout, TextArea, Display, CoreText, TextType, TextAlign } from 'twitch-core-ui';
import { Carrot, Pose } from './carrot/carrot'
import * as RTypes from './responses'
import { whatIs, OmnibarResponse, OmnibarError, ResponseType } from './api'

import './omnibar.css'

interface Props {

}

interface State {
  carrotPose: Pose
  searchTerm: string
  response: OmnibarResponse
  error: OmnibarError
}

export class OmniBar extends React.Component<Props, State> {
  private debounceTimeout: NodeJS.Timer;

  public state: State = {
    carrotPose: Pose.Hi,
    searchTerm: '',
    response: undefined,
    error: undefined,
  };

  constructor(props: Props, state: State) {
    super(props, state);
  }

  public render() {
    let response = <></>

    if (this.state.error) {
      response = (
        <Layout textAlign={TextAlign.Left}>
          <CoreText type={TextType.H3}>{this.state.error.message}</CoreText>
        </Layout>
      );
    }

    if (this.state.response) {
      switch (this.state.response.type) {
        case ResponseType.TwitchManifestURL:
          response = <RTypes.TwitchManifestURL response={this.state.response} />;
          break
        case ResponseType.IVSManifestURL:
          response = <RTypes.IVSManifestURL response={this.state.response} />;
          break
        case ResponseType.TwitchWeaverURL:
          response = <RTypes.TwitchWeaverURL response={this.state.response} />;
          break
        case ResponseType.IVSWeaverURL:
          response = <RTypes.IVSWeaverURL response={this.state.response} />;
          break
        case ResponseType.TwitchSegmentURL:
          response = <RTypes.TwitchSegmentURL response={this.state.response} />;
          break
        case ResponseType.IVSSegmentURL:
          response = <RTypes.IVSSegmentURL response={this.state.response} />;
          break
        case ResponseType.IVSChannelARN:
          response = <RTypes.IVSChannelARN response={this.state.response} />;
          break
        case ResponseType.IVSStreamKey:
          response = <RTypes.IVSStreamKey response={this.state.response} />;
          break
        case ResponseType.AVCProfile:
          response = <RTypes.AVCProfile response={this.state.response} />;
          break
        case ResponseType.GenericMessage:
          response = <RTypes.GenericMessage response={this.state.response} />;
          break
      }
    }

    return (
      <Layout>
        <Layout display={Display.Flex} padding={{ left: 2, right: 2 }} className="carrot-omnibar">
          <Layout className="carrot-icon">
            <Carrot pose={this.state.carrotPose} />
          </Layout>
          <Layout flexGrow={1} padding={{ top: 4, left: 4 }}>
            <TextArea id="carrot-omnibar" placeholder={`Hi, I'm a carrot, I'm going to try and help you`} onChange={this.onChange} value={this.state.searchTerm} />
            <Layout padding={{ top: 3 }}>
              {response}
            </Layout>
          </Layout>
        </Layout>
      </Layout>
    );
  }

  private whatIsThisThing = () => {
    if (!this.state.searchTerm) {
      this.setState({
        error: undefined,
        carrotPose: Pose.Hi,
      })

      return
    }

    this.setState({
      error: undefined,
      carrotPose: Pose.Thinking,
    })

    whatIs(this.state.searchTerm).then(
      (resp: OmnibarResponse) => {
        this.setState({
          carrotPose: Pose.ResultFound,
          response: resp,
        })
      }, (resp: OmnibarError) => {
        this.setState({
          error: resp,
          response: undefined,
          carrotPose: Pose.NotFound,
        })
      }
    )
  }

  private onChange = (event: React.FormEvent<HTMLTextAreaElement>) => {
    if (this.debounceTimeout) {
      clearTimeout(this.debounceTimeout)
      this.debounceTimeout = undefined;
    }

    let value: string | undefined = event.currentTarget.value;
    let pose = Pose.Hi;
    if (value) {
      pose = Pose.Thinking
    }

    this.setState({
      error: undefined,
      response: undefined,
      searchTerm: value,
      carrotPose: pose,
    });

    this.debounceTimeout = setTimeout(this.whatIsThisThing, 500)
  }
}
