import * as React from 'react';
import { Link } from 'react-router-dom'
import { Layout, CoreText, TextType, TextAlign, FontSize } from 'twitch-core-ui';
import { OmnibarResponse, ResponseType } from '../api'

interface Props {
  response: OmnibarResponse;
}

/*
avc1.64002A
*/

export class AVCProfile extends React.Component<Props, {}> {
  public render() {
    if (!this.props.response || this.props.response.type != ResponseType.AVCProfile) {
      return <></>
    }

    return (
      <Layout textAlign={TextAlign.Left}>
        <Layout padding={{ bottom: 2 }}>
          <CoreText type={TextType.H3}>Ah yes, who wants to decode hex in their head and cross reference with the h264 spec</CoreText>
        </Layout>
        <Layout padding={{ bottom: 1 }}>
          <CoreText type={TextType.P} fontSize={FontSize.Size4}>
            <strong>AVC Profile:</strong> { this.props.response.avc_profile_name }
          </CoreText>
        </Layout>
        <Layout padding={{ bottom: 1 }}>
          <CoreText type={TextType.P} fontSize={FontSize.Size4}>
              <strong>Level:</strong> { this.props.response.avc_profile_level }
          </CoreText>
        </Layout>
      </Layout>
    );
  }
}
