import * as React from 'react';
import { Link } from 'react-router-dom'
import { Layout, CoreText, TextType, TextAlign, FontSize } from 'twitch-core-ui';
import { OmnibarResponse, ResponseType } from '../api'

interface Props {
  response: OmnibarResponse;
}

export class GenericMessage extends React.Component<Props, {}> {
  public render() {
    if (!this.props.response || this.props.response.type != ResponseType.GenericMessage) {
      return <></>
    }

    return (
      <Layout textAlign={TextAlign.Left}>
        <Layout padding={{ bottom: 2 }}>
          <CoreText type={TextType.H3}>{this.props.response.generic_message}</CoreText>
        </Layout>
      </Layout>
    );
  }
}
