import * as React from 'react';
import { Link } from 'react-router-dom'
import { Layout, CoreText, TextType, TextAlign, FontSize } from 'twitch-core-ui';
import { OmnibarResponse, ResponseType } from '../api'

interface Props {
  response: OmnibarResponse;
}

/*
https://4da4a22026d3.us-west-2.playback.live-video.net/api/video/v1/us-west-2.298083573632.channel.hdviye1zVPxT.m3u8?player_version=1.0.0
*/

export class IVSManifestURL extends React.Component<Props, {}> {
  public render() {
    if (!this.props.response || this.props.response.type != ResponseType.IVSManifestURL) {
      return <></>
    }

    return (
      <Layout textAlign={TextAlign.Left}>
        <Layout padding={{ bottom: 2 }}>
          <CoreText type={TextType.H3}>It looks like you're working with an IVS Manifest URL!</CoreText>
        </Layout>
        <Layout padding={{ bottom: 1 }}>
          <CoreText type={TextType.P} fontSize={FontSize.Size4}>
            Perhaps you'd like to <Link to={'/channelviewer/' + this.props.response.ivs_customer_id + '/' + this.props.response.ivs_channel_region + '/' + this.props.response.ivs_channel_id}>view the channel's configuration</Link>
          </CoreText>
        </Layout>
        <Layout padding={{ bottom: 1 }}>
          <CoreText type={TextType.P} fontSize={FontSize.Size4}>
            Or maybe you'd prefer to <Link to={'/sessionviewer/' + this.props.response.ivs_customer_id + '/' + this.props.response.ivs_channel_region + '/' + this.props.response.ivs_channel_id}>view the channel's streaming sessions</Link>
          </CoreText>
        </Layout>
      </Layout>
    );
  }
}
