import * as React from 'react';
import { Link } from 'react-router-dom'
import { Layout, CoreText, TextType, TextAlign, FontSize } from 'twitch-core-ui';
import { OmnibarResponse, ResponseType } from '../api'
import {WeaverPayload} from "./weaver_payload";

interface Props {
  response: OmnibarResponse;
}

/*
https://video-edge-8f9db8.phx01.hls.live-video.net/v1/segment/CpIFESm8jvVGJ8nzn8l5B7sL36niKNaYnLc2uq0DXTo9g_QFu8h1ryjNG4RvG-db5kim0q-O4wR1q2-G7IophLeTOSZVh5xqbv7l72ZZ6bTmMX98O8POqyJF_jdfc--WG0Q67LTZ57_7o8TM60iRc1wM9y-0AHlZUHiisuY9GuGWHlPtE-Q_A5IFZmhQpoafW917iETCLx3ddy36SlzTTonGxasuvT72n_2fa8x2dkS2BoMVOHC7oU1u63F7HO6-ZDN0DOp_rvwyxP5yeNuvK8eY43INJtHl-kl9r_OORvdyYIUh2c0lWekPaA714YgCQFRTl-CmsuVIIUt5un_XIJcqo32NVD_Xo0ybMwYhOxneyxz7RbwUezflDPnFrDRd4FO5Gva1Lh_vIRPcveckm5NOhvlwsrSMZT_C9Uu9_C53MB3U_LH7cvRBCm0vpmOeRTNpAuldSKjj4bDsRtmqwiax19D0Cyfrs0SG-UY7HjgZRoTyZ8oO3dcI5539HSdKUdrG5CVq7rTyY14l2yC0G4WyOgPMe78picmsFYmt6MhKRSPXdhNN7W2kgLVHpq3brGfGBjiSGFSMBz7tzQlP_jBCPOziZ6-DuaN_Rt_J0OnSPjnverXVuE9M_TOrXe0myw0Cwuv0dsAh7hI7gMSPFe7jVt9jiNGyKrbn65QESUMdRpnl5c4j63rRrIAQ4BlP3vit098lcZeEgRgOvJdikYwjGP8YSF-iaxPyf6N6vWyONyW9_xu0hcJ-o8-ouEFPhhyvRC_VJEMjncdGZnFcAzc9dm1tbZN1ToTJ3VIadoe_4yxJsdwbkLsPMRl0slqLrdwF5KaAGb02AKi8enK_isy_X-Wvwm2pyVMoebxydyUtZZD1WBIQse78Txzw1ST6AlPb5CjohhoM9Gt76PzZwKe44bIH.ts

*/

export class IVSSegmentURL extends React.Component<Props, {}> {
  public render() {
    if (!this.props.response || this.props.response.type != ResponseType.IVSSegmentURL) {
      return <></>
    }

    return (
        <>
          <Layout textAlign={TextAlign.Left}>
            <Layout padding={{ bottom: 2 }}>
              <CoreText type={TextType.H3}>It looks like you're working with an IVS Segment URL!</CoreText>
            </Layout>
            <Layout padding={{ bottom: 1 }}>
              <CoreText type={TextType.P} fontSize={FontSize.Size4}>
                Perhaps you'd like to <Link to={'/channelviewer/' + this.props.response.ivs_customer_id + '/' + this.props.response.ivs_region + '/' + this.props.response.ivs_channel_id}>view the channel's configuration</Link>
              </CoreText>
            </Layout>
            <Layout padding={{ bottom: 1 }}>
              <CoreText type={TextType.P} fontSize={FontSize.Size4}>
                Or maybe you'd prefer to <Link to={'/sessionviewer/' + this.props.response.ivs_customer_id + '/' + this.props.response.ivs_region + '/' + this.props.response.ivs_channel_id}>view the channel's streaming sessions</Link>
              </CoreText>
            </Layout>
          </Layout>
          <WeaverPayload weaver_json={this.props.response.weaver_payload_json}/>
        </>
    );
  }
}
