import * as React from 'react';
import { Link } from 'react-router-dom'
import { Layout, CoreText, TextType, TextAlign, FontSize } from 'twitch-core-ui';
import { OmnibarResponse, ResponseType } from '../api'
import {WeaverPayload} from "./weaver_payload";

interface Props {
  response: OmnibarResponse;
}

/*
https://video-weaver.sea01.hls.live-video.net/v1/playlist/CoIFrHnnYVw4rU8AGH0DqQDZsAf6QfbIf66L9EGxb1KmLfilanhdOSxb0esT5Drwu4d4YwiPmxG3vHb7QiT5pB2z1dgV9zC-JRCuQKND29tkUe-Ycfr6tJvchft7rrl5wOgF_xRd7a-S_Sn_ahENqIQ-8RIOfOT39BdS8w2wOhPxze0hxGYrkl-eRAzYDkVKQ0o3rDuzxCEYC65Gvpgmo_xge1vcXIqy6IT2HLckswhdPMvibM-0yb8nb-81yB8lkCdKaln93kuu-2AtEQ8LFG4Kx5aahIRW4XBk6NffUdDOjwKy1e-xc1gbPLCfMLDuX_4PxmnQok4DWhjrDqMKSc-ykLcORDiVlAMWBy8BPytI1KMc_ubMIJTbTnVzAx2eDUskUC8cecCcjfryIyWGJ7qdgkC_fniuQ1KV8WGWtFX6uw1HP0D9UfYdPZXR6Ct65XBeP3yP0WhiKQtygBvNWsCN3xR2tWhHpOxlNlNJYYBh6CDZ5jgThOJGkkgXtFGr0UUtPrQ5rlAN2K9pxPkZzaQnAoR2srJFlRHa4SbwxSKK9KijQemgeDW6TQaVLIaTKdL1tOUzjQmNoiCej2zTM9uyiYjqCzopRkBMc-bk5nrSPseTVATsAlTvNova2ZxwsJUMdrQFCBirPP1lDX5tIndB03eGcHJbD8JcCJDpq4XIGEIKRaaLDc-dw0-V3U66lqKemqIipDCKeGCYQYTi2OZ0IJLmEsZcCr76jmlVw-9z5JTOMbdmictfIr_iSI2mfJH_bY-m4yveU7tpF6FC_wOjJip6Mk2XkchqtqYGAC_8MRNBMs3yNvhEco5Qx4xaDT56jHcnLjDMbTNe4OgyqvCSijiKEhAUfQrGqqGema2cKo1RRv_xGgzgBCtYz8TWmrPsAIk.m3u8

*/

export class IVSWeaverURL extends React.Component<Props, {}> {
  public render() {
    if (!this.props.response || this.props.response.type != ResponseType.IVSWeaverURL) {
      return <></>
    }

    return (
        <>
          <Layout textAlign={TextAlign.Left}>
            <Layout padding={{ bottom: 2 }}>
              <CoreText type={TextType.H3}>It looks like you're working with an IVS Weaver URL!</CoreText>
            </Layout>
            <Layout padding={{ bottom: 1 }}>
              <CoreText type={TextType.P} fontSize={FontSize.Size4}>
                Perhaps you'd like to <Link to={'/channelviewer/' + this.props.response.ivs_customer_id + '/' + this.props.response.ivs_region + '/' + this.props.response.ivs_channel_id}>view the channel's configuration</Link>
              </CoreText>
            </Layout>
            <Layout padding={{ bottom: 1 }}>
              <CoreText type={TextType.P} fontSize={FontSize.Size4}>
                Or maybe you'd prefer to <Link to={'/sessionviewer/' + this.props.response.ivs_customer_id + '/' + this.props.response.ivs_region + '/' + this.props.response.ivs_channel_id}>view the channel's streaming sessions</Link>
              </CoreText>
            </Layout>
          </Layout>
          <WeaverPayload weaver_json={this.props.response.weaver_payload_json}/>
        </>
    );
  }
}
