import * as React from 'react';
import { Link } from 'react-router-dom'
import { Layout, CoreText, TextType, TextAlign, FontSize } from 'twitch-core-ui';
import { OmnibarResponse, ResponseType } from '../api'

interface Props {
  response: OmnibarResponse;
}

/*
https://usher.ttvnw.net/api/channel/hls/lirik.m3u8?allow_source=true&fast_bread=true&p=282729&play_session_id=0f06ee2f177c597c383ed728de6725da&player_backend=mediaplayer&playlist_include_framerate=true&reassignments_supported=true&sig=2e004a1132fc2357a3e997106ffc9761e38bf461&supported_codecs=avc1&token=%7B%22adblock%22%3Atrue%2C%22authorization%22%3A%7B%22forbidden%22%3Afalse%2C%22reason%22%3A%22%22%7D%2C%22blackout_enabled%22%3Afalse%2C%22channel%22%3A%22lirik%22%2C%22channel_id%22%3A23161357%2C%22chansub%22%3A%7B%22restricted_bitrates%22%3A%5B%5D%2C%22view_until%22%3A1924905600%7D%2C%22ci_gb%22%3Afalse%2C%22geoblock_reason%22%3A%22%22%2C%22device_id%22%3A%2263da214e0c9639b1%22%2C%22expires%22%3A1603921306%2C%22extended_history_allowed%22%3Afalse%2C%22game%22%3A%22%22%2C%22hide_ads%22%3Atrue%2C%22https_required%22%3Atrue%2C%22mature%22%3Afalse%2C%22partner%22%3Afalse%2C%22platform%22%3A%22web%22%2C%22player_type%22%3A%22site%22%2C%22private%22%3A%7B%22allowed_to_view%22%3Atrue%7D%2C%22privileged%22%3Atrue%2C%22role%22%3A%22staff%22%2C%22server_ads%22%3Atrue%2C%22show_ads%22%3Afalse%2C%22subscriber%22%3Atrue%2C%22turbo%22%3Atrue%2C%22user_id%22%3A23751188%2C%22user_ip%22%3A%2276.102.90.234%22%2C%22version%22%3A2%7D&cdm=wv&player_version=1.2.0

*/

export class TwitchManifestURL extends React.Component<Props, {}> {
  public render() {
    if (!this.props.response || this.props.response.type != ResponseType.TwitchManifestURL) {
      return <></>
    }

    return (
      <Layout textAlign={TextAlign.Left}>
        <Layout padding={{ bottom: 2 }}>
          <CoreText type={TextType.H3}>It looks like you're working with a Twitch Manifest URL!</CoreText>
        </Layout>
        <Layout padding={{ bottom: 1 }}>
          <CoreText type={TextType.P} fontSize={FontSize.Size4}>
            Perhaps you'd like to <a target="_blank" href={'https://admin-panel.internal.justin.tv/twitch/users?text=' + this.props.response.twitch_channel + '&commit=Search'}>visit this channel in admin panel</a>
          </CoreText>
        </Layout>
        <Layout padding={{ bottom: 1 }}>
          <CoreText type={TextType.P} fontSize={FontSize.Size4}>
            Or maybe you'd prefer to <Link to={'/sessionviewer/twitch/us-west-2/' + this.props.response.twitch_channel}>view the channel's streaming sessions</Link>
          </CoreText>
        </Layout>
      </Layout>
    );
  }
}
