import * as React from 'react';
import { Link } from 'react-router-dom'
import { Layout, CoreText, TextType, TextAlign, FontSize } from 'twitch-core-ui';
import { OmnibarResponse, ResponseType } from '../api'
import {WeaverPayload} from "./weaver_payload";

interface Props {
  response: OmnibarResponse;
}

/*
https://video-edge-7eb984.sjc05.abs.hls.ttvnw.net/v1/segment/Cv0EJV7t0aYx4h4Ho04zoL5UjFaeVP0JE4OP-ARctPSufa5Uyawex-rnZUfvd-QYI6ozIU1rmrMFyjWSZbBoFeHCzXhWPEje39CCw-nRspUFjvITQ9q9zPLl4r1nbE6_uW10u9Amg2dT2Vz6RIivv8N6L3hi7qTzeHvXaeLfqzWM9SbbCMdHlI6UHxx-ZlkneqHAjnxp7dHoKb9Ym_OKcAipM7r7cOPxLw_p5P-WCUI4rffJUS_SI_5cp_x97b8B8uPCr3gLzU60jsD1prplmHTTN0Zzc_z0P-RWh-UYsBWSdEdfQS-iMD4gTbrrI6Cw3bg9iACjUDiKrqaVGUIiaJpYvOSsVkljeOEU-LwWjFf8KPZXf_5T6Gs6y4yE09d-ksVlgxofmI28zawJoAyhhpFKwGt_i2imt34lFBsVi7GBePSFF-d-M-r1qWCY_lRTmzVeoqRM8GetAk1zXdk1Pxb4_IUuEQYh5u3tReqLh-TwUBcTPqSigfP_smFGmgalxcwfpNbzAe3-QImBeuJu5Lum_yTEwKUPWI5QQFUj1ux42BpSQlxAyyqhlXERyenHgSDIAcd9ot1fNoMPIuDThWSOMcxbBnauy0tjro4LVRqK1Xo9dXMZPR7Gxq5V_DsVvTxxC8vEd9_qNT0ZhBlbb_I9qJPlf7DeEgp9aYUBV-xlt_FgRRm9dNWUD6ZIrxIX7gekkRP4RvnVmXzwtqCFlUiwhsRe1h2-TXdpBELjRaI3L2BREtG3lGnCpLZyUMMUY318lE2El_-WKSoDSyx-2QpX7XG4NLywl5wQ8T1if8Ey2cx64CdngWB6S4owAmd590CIFnD3hCPbZPpmdVFrmhIQfbtezqlwW6dmedUnkZTfMhoMT_6ex8z1IVuY74cB.ts

*/

export class TwitchSegmentURL extends React.Component<Props, {}> {
  public render() {
    if (!this.props.response || this.props.response.type != ResponseType.TwitchSegmentURL) {
      return <></>
    }

    return (
        <>
          <Layout textAlign={TextAlign.Left}>
            <Layout padding={{ bottom: 2 }}>
              <CoreText type={TextType.H3}>It looks like you're working with a Twitch Segment URL!</CoreText>
            </Layout>
            <Layout padding={{ bottom: 1 }}>
              <CoreText type={TextType.P} fontSize={FontSize.Size4}>
                Perhaps you'd like to <a target="_blank" href={'https://admin-panel.internal.justin.tv/twitch/users/' + this.props.response.twitch_channel_id}>visit this channel in admin panel</a>
              </CoreText>
            </Layout>
            <Layout padding={{ bottom: 1 }}>
              <CoreText type={TextType.P} fontSize={FontSize.Size4}>
                Or maybe you'd prefer to <Link to={'/sessionviewer/twitch/us-west-2/' + this.props.response.twitch_channel}>view the channel's streaming sessions</Link>
              </CoreText>
            </Layout>
          </Layout>
          <WeaverPayload weaver_json={this.props.response.weaver_payload_json}/>
        </>
    );
  }
}
