import * as React from 'react';
import { Link } from 'react-router-dom'
import { Layout, CoreText, TextType, TextAlign, FontSize } from 'twitch-core-ui';
import { OmnibarResponse, ResponseType } from '../api'
import { WeaverPayload } from './weaver_payload'

interface Props {
  response: OmnibarResponse;
}

/*
https://video-weaver.atl01.hls.ttvnw.net/v1/playlist/CpYF2guSOJtEWyN7GV8P-e6gdDjHgg9n280adV54uPAroqfTwEIGlrQzxCpK5kZSBVMNKZIzmf4OPqPso67BoIh9JE0zulmWpb1euyRj8CtQ1EmriRZrmd3FdErW9RlkYHyh-T-ZT0DbTY3_tJ4eeGZyOz71E3CPvV1jKnkMaU9-mg5aLwETjmDQfwVihR8d3e0h73NpZNhqusPt4HGeIClYelgBvDCdeANXyqiL_9RbrIRBg8JdrBgS_kLz1AmzIzKEOLbIZwd2kE1A1ZFkiXzZ24aNkhAo7MtOW0PPNOPfJ9CleY6mmnXP8wush5sk-VRe-M_XVXyk4pPiuEKo4M2_hwn3Uyg1_Kh46V8AjFWul4Xnl0VRjbSgJxPr0gu3MpY2hG_-hGn08ZrCcUZpWUA_HVSMJlj1HYpBJmJ1jYxtqO9mpO1g-PynnwlEpFTyh4Q1zq3NIwU12H65_MhST6Px4RV3uEVjs913QGYEppWw2xQ3X1BCAQuZClccioM8c5hPn8y8hkr5PUXz5oix1iv9xnIU41qgnWXlNs5hk8OEP-oir3SPEJvW8D-y2cPbliLCy8IuX_iROn7wgP0FkVxPxcPHzXJdm85RMvefvA-xCynb2qdNsOltTkLmmrR901B-lR1FYDJ2ruseAgzQEoct1m8PFyYME66mlyFHv8yHrOVaiYxui_G1O04CpSUG2m325vZYt-5LtkWaJPoQ49obcoK-IJPUDRIJurQBxNxujPyItI8yDW36UBkUm10yuBjWLBdtK9028j5O89ZH2wrvPOwNjwEbXUQ7OIQl3oZ0Nc9zsJibMZGmKJPfx0wWBCJ-aUdZ2eX0CsVr48LPZRhDAi8AMCENi1INf7bjFUbyD5y8XigYKGESEK6ERvWsOvUKVnNJ8kQv0sQaDAh5lqn1r4BTptsgSA.m3u8

*/

export class TwitchWeaverURL extends React.Component<Props, {}> {
  public render() {
    if (!this.props.response || this.props.response.type != ResponseType.TwitchWeaverURL) {
      return <></>
    }

    return (
        <>
          <Layout textAlign={TextAlign.Left}>
            <Layout padding={{ bottom: 2 }}>
              <CoreText type={TextType.H3}>It looks like you're working with a Twitch Weaver URL!</CoreText>
            </Layout>
            <Layout padding={{ bottom: 1 }}>
              <CoreText type={TextType.P} fontSize={FontSize.Size4}>
                Perhaps you'd like to <a target="_blank" href={'https://admin-panel.internal.justin.tv/twitch/users/' + this.props.response.twitch_channel_id}>visit this channel in admin panel</a>
              </CoreText>
            </Layout>
            <Layout padding={{ bottom: 1 }}>
              <CoreText type={TextType.P} fontSize={FontSize.Size4}>
                Or maybe you'd prefer to <Link to={'/sessionviewer/twitch/us-west-2/' + this.props.response.twitch_channel}>view the channel's streaming sessions</Link>
              </CoreText>
            </Layout>
          </Layout>
          <WeaverPayload weaver_json={this.props.response.weaver_payload_json}/>
        </>
    );
  }
}
