import * as React from 'react';
import {Background, CoreText, FontSize, Layout, StyledLayout, TextAlign, TextType} from 'twitch-core-ui';

interface Props {
    weaver_json: string;
}

export class WeaverPayload extends React.Component<Props, {}> {
    public render() {
        if (!this.props.weaver_json) {
            return <></>
        }

        let payload = JSON.parse(this.props.weaver_json)
        let prettyJSON = JSON.stringify(payload, null, 2);

        return (
            <Layout padding={{ top:3 }} textAlign={TextAlign.Left}>
                <Layout padding={{ bottom: 2 }}>
                    <CoreText type={TextType.H3}>Great News! It looks like you have access to our internal tools, this means you can view the whole payload!</CoreText>
                </Layout>
                <StyledLayout background={Background.Alt} padding={2} fontSize={FontSize.Size4}>
                    <pre>{prettyJSON}</pre>
                </StyledLayout>
            </Layout>
        );
    }
}
