import * as React from 'react';
import { Layout, Button, ButtonType, Display, JustifyContent } from 'twitch-core-ui';

import './paging.css'

interface Props {
  triggerNextPage: () => void
  triggerPrevPage: () => void
  nextPageExists: boolean
  prevPageExists: boolean
  position: Position
  loading: boolean
}

interface State {

}

export enum Position {
  Before,
  After,
}

export class Paging extends React.Component<Props, State> {
  public state: State = {

  };

  constructor(props: Props, state: State) {
    super(props, state);
  }

  public render() {
    let paging = (
      <Layout display={Display.Flex} justifyContent={JustifyContent.End} margin={{top: this.props.position == Position.Before ? 0 : 1, bottom: this.props.position == Position.After ? 0 : 1}}>
        <Layout>
          <Button type={ButtonType.Text} disabled={this.props.loading || !this.props.prevPageExists} onClick={() => this.props.triggerPrevPage()}>Prev</Button>
        </Layout>
        <Layout margin={{left:1}}>
          <Button type={ButtonType.Text} disabled={this.props.loading || !this.props.nextPageExists} onClick={() => this.props.triggerNextPage()}>Next</Button>
        </Layout>
      </Layout>
    )

    if (this.props.position == Position.Before) {
      return (
        <>
          {paging}
          {this.props.children}
        </>
      );
    }

    return (
      <>
        {this.props.children}
        {paging}
      </>
    );
  }
}
