import * as React from 'react';
import {FormGroup, FormGroupOrientation, Select} from 'twitch-core-ui';

interface Props {
    setValue: (text: string | undefined) => string | undefined;
    defaultValue?: string | undefined;
    label: string;
    orientation?: FormGroupOrientation;
    options: Option[];
}

interface State {
    validationError?: string;
}

export interface Option {
    value: string;
    label: string;
    selected: boolean;
}

export class SelectInput extends React.Component<Props, State> {
    public state: State = {};

    constructor(props: Props, state: State) {
        super(props, state);
    }

    public componentDidMount() {
        if (this.props.defaultValue === undefined) {
            this.props.options.map((option) => {
                if (option.selected) {
                    this.setState({
                        validationError: this.props.setValue(option.value),
                    });
                }
            });
        }
    }

    public render() {
        return (
            <FormGroup error={this.state.validationError !== undefined} errorMessage={this.state.validationError} label={this.props.label}
                       orientation={this.props.orientation}>
                <Select onChange={this.onChange} defaultValue={this.props.defaultValue}>
                    {this.props.options.map((option, index) => (
                        <option key={index} value={option.value}>{option.label}</option>
                    ))}
                </Select>
            </FormGroup>
        );
    }

    private onChange = (event: React.FormEvent<HTMLSelectElement>) => {
        let value: string | undefined = event.currentTarget.value;
        if (value === '') {
            value = undefined;
        }

        this.setState({
            validationError: this.props.setValue(value),
        });
    }
}
