import * as React from 'react';
import { Background, CoreText, FontSize, Layout, StyledLayout, TextType } from 'twitch-core-ui';
import { UserInfo } from '../../App';
import { SideBarLink } from './side-bar-link';

let publicRoutes = [
  {
    path: '/account',
    name: 'Account Viewer',
  },
  {
    path: '/sessionviewer',
    name: 'Session Viewer',
  },
  {
    path: '/reports',
    name: 'Reports',
  },

];

let toolsRoutes = [
  {
    path: '/health',
    name: 'Service Health',
  },
  {
    path: '/videoanalysis',
    name: 'Video Analysis',
  },
];

interface Props {
  userInfo: UserInfo | null;
}

export class SideBar extends React.Component<Props, {}> {
  public render() {
    let tools = (<></>);

    if (this.props.userInfo && this.props.userInfo.permissions && this.props.userInfo.permissions.can_access_tools) {
      tools = (
        <>
          <Layout padding={1}>
            <CoreText fontSize={FontSize.Size6} type={TextType.Strong}>Tools</CoreText>
          </Layout>
          {toolsRoutes.map((route, index) => (
            <SideBarLink
              key={index}
              linkTo={route.path}
            >
              {route.name}
            </SideBarLink>
          ))}
        </>
      );
    }

    return (
      <StyledLayout
        className="sidebar"
        fullHeight
        background={Background.Alt}
        elevation={4}
      >
        <SideBarLink linkTo="/" exact={true}>Home</SideBarLink>
        <Layout padding={1}>
          <CoreText fontSize={FontSize.Size6} type={TextType.Strong}>Customer</CoreText>
        </Layout>
        {publicRoutes.map((route, index) => (
          <SideBarLink
            key={index}
            linkTo={route.path}
          >
            {route.name}
          </SideBarLink>
        ))}
        {tools}
      </StyledLayout>
    );
  }
}
