import { LocationDescriptor } from 'history';
import * as React from 'react';
import { NavLink } from 'react-router-dom';
import { BorderRadius, Display, FontSize, InjectStyledLayout } from 'twitch-core-ui';

// This feels like a terrible hack
const BASE_CLASS = 'tw-interactable--inverted tw-interactable';
const ACTIVE_CLASS = 'tw-interactable--selected';

interface Props {
  linkTo: LocationDescriptor;
  exact?: boolean;
  children: React.ReactNode;
}

export const SideBarLink: React.SFC<Props> = (props: Props) => {
  return (
    <InjectStyledLayout
      borderRadius={BorderRadius.Medium}
      display={Display.Block}
      fontSize={FontSize.Size5}
      padding={{ x: 1, y: 1 }}
      fullWidth
    >
      <NavLink
        activeClassName={ACTIVE_CLASS}
        className={BASE_CLASS}
        exact={props.exact}
        to={props.linkTo}
      >
        {props.children}
      </NavLink>
    </InjectStyledLayout>
  );
};
