import * as React from 'react';
import {
  Display,
  Interactable,
  InteractableType,
  Layout,
  Tooltip,
  TooltipAlign,
  TooltipDirection,
} from 'twitch-core-ui';

interface Props {
  value: string;
  displayValue?: string;
  disabled?: boolean;
  disabledMessage?: string;
  refDelegate?: (e: HTMLDivElement) => void;
  onClick: React.MouseEventHandler<HTMLElement>;
  selected?: boolean;
}

export class TimeInteractable extends React.Component<Props, {}> {
  public render() {
    const optionElement = this.optionElement();
    if (this.props.disabled && this.props.disabledMessage) {
      return (
        <Tooltip
          direction={TooltipDirection.Bottom}
          align={TooltipAlign.Left}
          width={130}
          display={Display.Flex}
          label={this.props.disabledMessage}
        >
          {optionElement}
        </Tooltip>
      );
    }
    return optionElement;
  }

  private optionElement() {
    const { displayValue, selected, value, onClick, disabled } = this.props;
    return (
      <Interactable
        hover={selected}
        data-value={value}
        data-display-value={displayValue}
        onClick={onClick}
        disabled={disabled}
        type={InteractableType.Alpha}
      >
        <Layout refDelegate={this.props.refDelegate} padding={0.5}>
          {displayValue || value}
        </Layout>
      </Interactable>
    );
  }
}
