import { APIError } from './api';

export class APIResponse<T> {
  public status: number;
  public error?: APIError;
  public requestError?: Error;
  public body?: T;

  public isSuccess() {
    return this.status >= 200 && this.status < 400 && !this.requestError;
  }

  public isError() {
    return !this.isSuccess();
  }
}
