import * as React from 'react';
import { Redirect, match } from 'react-router-dom';
import { Layout, LoadingSpinner, Display, CoreText, TextType } from 'twitch-core-ui';
import { ChannelList } from '../../../channelviewer/components/channellist'
import { LimitBreachList } from '../../../../components/limitbreaches'

interface URLParams {
  customer_id: string;
  region: string;
}

interface Props {
  match: match<URLParams>;
}

interface State {
  processing: boolean;
}

export class AccountView extends React.Component<Props, State> {
  public state: State = {
    processing: false,
  };

  public render() {
    if (this.props.match.path.startsWith('/channelviewer')) {
      return <Redirect to={'/account/' + this.props.match.params.customer_id + '/' + this.props.match.params.region} />
    }

    if (this.state.processing) {
      return (
        <LoadingSpinner />
      );
    }

    return (
      <Layout>
        <Layout padding={{bottom: 3}}>
          <CoreText type={TextType.H3}>Account Overview for {this.props.match.params.customer_id} in {this.props.match.params.region}</CoreText>
        </Layout>
        <Layout display={Display.Flex}>
          <Layout flexGrow={2} padding={2}>
            <ChannelList customer_id={this.props.match.params.customer_id} region={this.props.match.params.region} />
          </Layout>
          <Layout flexGrow={1} padding={2}>
            <LimitBreachList customer_id={this.props.match.params.customer_id} region={this.props.match.params.region} session_id={""} />
          </Layout>
        </Layout>
      </Layout>
    );
  }
}
