import { API } from 'lib/api';

export interface GetChannelsResponse {
  stream_configs: StreamConfig[];
  next_page_token: string
}

export interface StreamConfig {
  customer_id: string;
  stream_config_id: string;
  nickname: string;
  playback_auth_required: boolean;
  recording_s3_bucket_name: string;
  pricing_mode: string;
  playback_latency_mode: string;
}

export interface StreamConfigDetail {
  stream_config: StreamConfig;
  stream_keys: StreamKey[];
}

export interface StreamKey {
  id: string;
  customer_id: string;
  content_id: string;
}

export async function getStreamConfigs(customerID: string, region: string, pageToken: string): Promise<GetChannelsResponse> {
  let path = `/api/channelviewer/` + customerID + '/' + region;

  if (pageToken) {
    path += '?page_token=' + encodeURIComponent(pageToken)
  }

  const response = await API.get<GetChannelsResponse>(path, {});

  if (response.error) {
    response.error.status = response.status
    return Promise.reject(response.error);
  }

  if (response.body === undefined) {
    return undefined;
  }

  return response.body;
}

export async function getStreamConfigDetail(customerID: string, region: string, streamConfigID: string): Promise<StreamConfigDetail | undefined> {
  const path = `/api/channelviewer/` + customerID + '/' + region + '/' + streamConfigID;

  const response = await API.get<StreamConfigDetail>(path, {});
  if (response.body === undefined) {
    return undefined;
  }
  return response.body;
}
