import * as React from 'react';
import { Route, Switch } from 'react-router-dom';
import { Layout } from 'twitch-core-ui';
import { ChannelDetail } from './pages/channeldetail';
import { AccountViewerHome } from '../accountviewer/pages/home';
import { AccountView } from '../accountviewer/pages/accountview';

export class ChannelViewerPage extends React.Component<{}, {}> {
  public render() {
    return (
      <Layout fullHeight padding={3}>
        <Switch>
          <Route path="/channelviewer/:customer_id/:region/:stream_config_id" exact component={ChannelDetail} />

          // We changed some routes around, so make sure old links still work
          <Route path="/channelviewer" exact component={AccountViewerHome} />
          <Route path="/channelviewer/:customer_id/:region" exact component={AccountView} />
        </Switch>
      </Layout>
    );
  }
}
