import { API } from 'lib/api';

export interface PoPHealthResponse {
  pops: PoPHealth[];
}

export interface PoPHealth {
  id: string;
  buffer_empties_per_mw: number;
  percent_time_starving: number;
  backbone_in: number;
  backbone_out: number;
  backbone_max: number;
  minutes_watched: number;
  concurrent_broadcasters: number;
  is_serving_edge: boolean;
  is_serving_weaver: boolean;
  network_environment: string;
  is_serving_ingest: boolean;
  ingest_health_status: string;
  lat: number;
  long: number;
  is_origin_dc: boolean;
  edge_in: number;
  edge_out: number;
  edge_max: number;
}

export async function getPoPHealth(): Promise<PoPHealth[]> {
  const path = `/api/health/pop`;

  const response = await API.get<PoPHealthResponse>(path, {});
  if (response.body === undefined) {
    return [];
  }
  return response.body.pops;
}
