import * as React from 'react';
// @ts-ignore
import { DataClassification, PanelItem, PanelItemWarning } from 'components/panel-item/panel-item';
// @ts-ignore
import { Tooltip, SVG, SVGAsset, SVGType, TooltipDirection, Background, BorderRadius, Button, ButtonType, CoreText, Display, FlexDirection, FlexWrap, FormGroupOrientation, JustifyContent, Layout, LoadingSpinner, StyledLayout, Table, TableBody, TableCell, TableHeader, TableHeading, TableRow, TextType } from 'twitch-core-ui';
import { PoPHealth } from '../../api';

import './styles.css';

export interface Props {
  pop: PoPHealth;
}

export class PoPHealthItem extends React.Component<Props, {}> {
  public render() {
    let pop = this.props.pop;
    let popIsWarn = false;
    let popIsCrit = false;

    let bemwWarning = <></>
    if (pop.buffer_empties_per_mw >= 0.1) {
      popIsWarn = true;
      bemwWarning = <>
        <Tooltip label={'Buffer empties per minute watched is above the 0.1 threshold indicating playback QoS issues'} direction={TooltipDirection.Right} width={200}>
          <SVG type={SVGType.Warn} width={16} height={16} asset={SVGAsset.Warning} />&nbsp;
        </Tooltip>
      </>;
    }

    let popClassName = '';
    if (popIsWarn) {
      popClassName = 'pop-health-pop-warn';
    }

    if (popIsCrit) {
      popClassName = 'pop-health-pop-crit';
    }

    let popFlags: string[] = [];
    let ingestStats = (<></>);
    let bbStats = (<></>);
    let edgeNetStats = (<></>);

    if (pop.is_origin_dc) {
      popFlags.push('origin');
    }

    if (pop.network_environment == 'CDN') {
      popFlags.push('external');
    }

    if (pop.is_serving_edge) {
      popFlags.push('edge');
    }

    if (pop.is_serving_weaver) {
      popFlags.push('playlist');
    }

    if (pop.is_serving_ingest) {
      popFlags.push('ingest');

      ingestStats = (
        <>
          CCB: {this.formatInt(pop.concurrent_broadcasters)} PTS: {this.formatPercent(pop.percent_time_starving)}
        </>
      );
    }

    if (pop.network_environment == 'ONNET' || pop.network_environment == undefined) {
      bbStats = (
        <>
          In: {this.formatbtoGb(pop.backbone_in)} ({this.formatBBPercent(pop.backbone_in, pop.backbone_max)}) Out: {this.formatbtoGb(pop.backbone_out)} ({this.formatBBPercent(pop.backbone_out, pop.backbone_max)})
        </>
      );

      edgeNetStats = (
          <>
            In: {this.formatbtoGb(pop.edge_in)} ({this.formatBBPercent(pop.edge_in, pop.edge_max)}) Out: {this.formatbtoGb(pop.edge_out)} ({this.formatBBPercent(pop.edge_out, pop.edge_max)})
          </>
      );
    }

    let popFlagsString = popFlags.join(', ');

    return (
        <TableRow className={popClassName}>
          <TableCell>{pop.id}</TableCell>
          <TableCell>{popFlagsString}</TableCell>
          <TableCell>{this.formatInt(pop.minutes_watched)}</TableCell>
          <TableCell>{this.formatDecimal(pop.buffer_empties_per_mw)} {bemwWarning}</TableCell>
          <TableCell>{ingestStats}</TableCell>
          <TableCell>{bbStats}</TableCell>
          <TableCell>{edgeNetStats}</TableCell>
        </TableRow>
    );
  }

  private formatbtoGb(val: number): string {
    if (val === undefined || val === null) {
      return 'Unknown';
    }

    let output = (val / 1000000000)
    let unit = 'Gbps';

    if (output > 1000) {
      output = output / 1000
      unit = 'Tbps';
    }

    return output.toFixed(2) + ' ' + unit;
  }

  private formatInt(val: number): string {
    if (val === undefined || val === null) {
      return 'Unknown';
    }

    return val.toLocaleString();
  }

  private formatDecimal(val: number): string {
    if (val === undefined || val === null) {
      return 'Unknown';
    }

    return val.toFixed(2);
  }

  private formatPercent(val: number): string {
    if (val === undefined || val === null) {
      return 'Unknown';
    }

    return (val * 100).toFixed(2) + '%';
  }

  private formatBBPercent(val: number, max: number): string {
    if (val === undefined || val === null || max === undefined || max === null) {
      return 'Unknown';
    }

    return (val / max * 100).toFixed(2) + '%';
  }
}
