import { API } from 'lib/api';
import { TimeStamp } from 'lib/api';
import { QueryResult } from './model';

export interface Query {
  query_type: string;
  start: Date;
  end: Date;
  play_session_id?: string;
  broadcast_session_id?: string;
}

export interface SubmitQueryResponse {
  query_id: string;
}

export async function submitQuery(query: Query): Promise<string | undefined> {
  const path = `/api/reports/`;

  const response = await API.post<SubmitQueryResponse>(path, {
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify(query),
  });

  if (response.error) {
    return Promise.reject(response.error);
  }

  if (response.body === undefined) {
    return Promise.reject('Empty Response');
  }

  return response.body.query_id;
}

export interface GetQueryResultResponse {
  Result: QueryResult;
}

export async function getQueryResult(queryID: string): Promise<QueryResult | undefined> {
  const path = `/api/reports/` + queryID;

  const response = await API.get<GetQueryResultResponse>(path);

  if (response.error) {
    return Promise.reject(response.error);
  }

  if (response.body === undefined) {
    return Promise.reject('Empty Response');
  }

  return response.body.Result;
}

export enum QueryStatus {
  QUEUED = 0,
  EXECUTING = 1,
  SUCCESS = 2,
  FAILURE = 3,
}

export interface QuerySummary {
  query_id: string;
  requested_at: TimeStamp;
  status: QueryStatus;
  ttl: number;
  label: string;
}

export interface ListQueriesResponse {
  queries: QuerySummary[];
}

export async function listQueries(): Promise<QuerySummary[]> {
  const path = `/api/reports/`;

  const response = await API.get<ListQueriesResponse>(path);

  if (response.error) {
    return Promise.reject(response.error);
  }

  if (response.body === undefined) {
    return Promise.reject('Empty Response');
  }

  return response.body.queries;
}
