import { TimeStamp } from 'lib/api';

export interface Result {
  play_sessions_by_minutes_watched: PlaySessionByMinutesWatched[];
  play_sessions_by_bemw: PlaySessionByBEMW[];
}

export interface PlaySession {
  time: TimeStamp;
  client_time: TimeStamp;
  last_minute_watched_time: TimeStamp;
  play_session_id: string;
  broadcast_id: number;
  manifest_cluster: string;
  node: string;
  asn: string;
  time_since_load_start: number;
}

export interface PlaySessionByMinutesWatched {
  minutes_watched: number;
  play_session_summary: PlaySession;
}

export interface PlaySessionByBEMW {
  minutes_watched: number;
  buffer_empties: number;
  bemw: number;
  play_session_summary: PlaySession;
}
