import { TimeStamp } from 'lib/api';

export interface Result {
  playback_summary: PlaybackSummary;
  video_errors: VideoError[];
  play_session_info: PlaySessionInfo;
}

export interface PlaybackSummary {
  first_mw_time: TimeStamp;
  last_mw_time: TimeStamp;
  minutes_watched: number;
  buffer_empties: number;
  errors: number;
  seconds_buffering: number;
  percent_time_buffering: number;
  avg_latency: number;
  p50_latency: number;
}

export interface VideoError {
  time: TimeStamp;
  video_error_code: number;
  video_error_message: string;
  video_error_recoverable: boolean;
  video_error_result: string;
  video_error_source: string;
  video_error_value: number;
  video_buffer_size: number;
  buffer_empty_count: number;
  playing_ad: boolean;
  url: string;
  error_extra: number;
  error_type: string;
  error_what: number;
}

export interface PlaySessionInfo {
  time: TimeStamp;
  platform: string;
  player: string;
  core_version: string;
  backend: string;
  backend_version: string;
  channel: string;
  content_id: string;
  customer_id: string;
  cluster: string;
  node: string;
  serving_id: string;
  country: string;
  live: boolean;
  vod_cdn_origin: string;
  low_latency: boolean;
  client_app: string;
  app_version: string;
  browser_family: string;
  browser_version: string;
  os: string;
  os_name: string;
  os_version: string;
  device_manufacturer: string;
  time_for_player_core_load: number;
  time_for_token_load: number;
  time_to_master_playlist_ready: number;
  time_to_variant_ready: number;
  time_to_segment_ready: number;
  time_since_load_start: number;
  device_model: string;
  device_os_version: string;
}
