import * as React from 'react';
import { DataClassification, PanelItem } from 'components/panel-item/panel-item';
import { Result } from 'modules/reports/model/play-session-info';
import { CoreText, Display, FlexDirection, FlexWrap, Layout, StyledLayout, Table, TableBody, TableCell, TableHeader, TableHeading, TableRow, TextAlign, TextType } from 'twitch-core-ui';
//import './styles.scss';

export interface Props {
  data: Result;
}

export class Page extends React.Component<Props, {}> {
  public render() {

    if (!this.props.data.play_session_info) {
      return (
        <Layout textAlign={TextAlign.Center}>
          <CoreText type={TextType.H3}>Empty Result</CoreText>
        </Layout>
      );
    }

    let errorList = (<></>);

    if (this.props.data.video_errors) {
      errorList = (
        <Layout padding={3}>
          <Layout padding={{ bottom: 2 }}>
            <CoreText type={TextType.H3}>Player Errors</CoreText>
          </Layout>
          <Table>
            <TableHeader>
              <TableHeading label="Time" />
              <TableHeading label="Error Code" />
              <TableHeading label="Error Message" />
              <TableHeading label="Error Recoverable" />
              <TableHeading label="Error Result" />
              <TableHeading label="Error Source" />
              <TableHeading label="Error Value" />
              <TableHeading label="Video Buffer Size" />
              <TableHeading label="Buffer Empty Count" />
              <TableHeading label="Playing Ad" />
              <TableHeading label="URL" />
              <TableHeading label="Error Extra" />
              <TableHeading label="Error Type" />
              <TableHeading label="Error What" />
            </TableHeader>
            <TableBody>
              {this.props.data.video_errors.map((error, index) => (
                <TableRow key={index}>
                  <TableCell>{this.context.time.defaultFormat(error.time)}</TableCell>
                  <TableCell>{error.video_error_code}</TableCell>
                  <TableCell>{error.video_error_message}</TableCell>
                  <TableCell>{error.video_error_recoverable}</TableCell>
                  <TableCell>{error.video_error_result}</TableCell>
                  <TableCell>{error.video_error_source}</TableCell>
                  <TableCell>{error.video_error_value}</TableCell>
                  <TableCell>{error.video_buffer_size}</TableCell>
                  <TableCell>{error.buffer_empty_count}</TableCell>
                  <TableCell>{error.playing_ad ? 'True' : 'False'}</TableCell>
                  <TableCell>{error.url}</TableCell>
                  <TableCell>{error.error_extra}</TableCell>
                  <TableCell>{error.error_type}</TableCell>
                  <TableCell>{error.error_what}</TableCell>
                </TableRow>
              ))}
            </TableBody>
          </Table>
        </Layout>
      );
    }

    return (
      <Layout display={Display.Flex} flexDirection={FlexDirection.Column}>
        <Layout display={Display.Flex} flexDirection={FlexDirection.Row} flexWrap={FlexWrap.Wrap}>
          <StyledLayout elevation={2} margin={3} padding={2} flexGrow={1}>
            <Layout padding={{ bottom: 2 }}>
              <CoreText type={TextType.H3}>Session Summary</CoreText>
            </Layout>
            <Layout padding={{ bottom: 2 }}>
              <PanelItem name="Session Start" dataClassification={DataClassification.CustomerOnly} value={this.context.time.defaultFormat(this.props.data.play_session_info.time)} />
              <PanelItem name="Minutes Watched" dataClassification={DataClassification.CustomerOnly} value={this.props.data.playback_summary.minutes_watched || 0} />
              <PanelItem name="Buffer Empties" dataClassification={DataClassification.CustomerOnly} value={this.props.data.playback_summary.buffer_empties || 0} />
              <PanelItem name="Seconds Buffering" dataClassification={DataClassification.CustomerOnly} value={this.props.data.playback_summary.seconds_buffering || 0} />
              <PanelItem name="Percent Time Buffering" dataClassification={DataClassification.CustomerOnly} value={this.props.data.playback_summary.percent_time_buffering || 0} />
              <PanelItem name="Errors" dataClassification={DataClassification.CustomerOnly} value={this.props.data.playback_summary.errors || 0} />
              <PanelItem name="P50 Latency (ms)" dataClassification={DataClassification.CustomerOnly} value={this.props.data.playback_summary.p50_latency || 0} />
            </Layout>
          </StyledLayout>
          <StyledLayout elevation={2} margin={3} padding={2} flexGrow={1}>
            <Layout padding={{ bottom: 2 }}>
              <CoreText type={TextType.H3}>Player Info</CoreText>
            </Layout>
            <Layout padding={{ bottom: 2 }}>
              <PanelItem name="Platform" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.platform} />
              <PanelItem name="Player" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.player} />
              <PanelItem name="Core Version" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.core_version} />
              <PanelItem name="Backend" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.backend} />
              <PanelItem name="Backend Version" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.backend_version} />
              <PanelItem name="Client App" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.client_app} />
              <PanelItem name="App Version" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.app_version} />
              <PanelItem name="Browser Family" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.browser_family} />
              <PanelItem name="Browser Version" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.browser_version} />
              <PanelItem name="Operating System" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.os} />
              <PanelItem name="Operating System Name" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.os_name} />
              <PanelItem name="Operating System Version" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.os_version} />
              <PanelItem name="Device Manufacturer" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.device_manufacturer} />
              <PanelItem name="Device Model" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.device_model} />
              <PanelItem name="Device OS Version" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.device_os_version} />
            </Layout>
          </StyledLayout>
          <StyledLayout elevation={2} margin={3} padding={2} flexGrow={1}>
            <Layout padding={{ bottom: 2 }}>
              <CoreText type={TextType.H3}>Service Info</CoreText>
            </Layout>
            <Layout padding={{ bottom: 2 }}>
              <PanelItem name="Cluster" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.cluster} />
              <PanelItem name="Node" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.node} />
              <PanelItem name="Serving ID" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.serving_id} />
              <PanelItem name="Country" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.country} />
              <PanelItem name="Low Latency" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.low_latency ? 'True' : 'False'} />
              <PanelItem name="Is Live" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.live ? 'True' : 'False'} />
              <PanelItem name="VOD CDN Origin" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.vod_cdn_origin} />
              <PanelItem name="Channel" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.channel} />
              <PanelItem name="Customer ID" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.customer_id} />
              <PanelItem name="Content ID" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.content_id} />
            </Layout>
          </StyledLayout>
          <StyledLayout elevation={2} margin={3} padding={2} flexGrow={1}>
            <Layout padding={{ bottom: 2 }}>
              <CoreText type={TextType.H3}>Startup Timings</CoreText>
            </Layout>
            <Layout padding={{ bottom: 2 }}>
              <PanelItem name="Time to player core load" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.time_for_player_core_load || 0} />
              <PanelItem name="Time to token load (Twitch only)" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.time_for_token_load || 0} />
              <PanelItem name="Time to master playlist ready" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.time_to_master_playlist_ready || 0} />
              <PanelItem name="Time to variant playlist ready" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.time_to_variant_ready || 0} />
              <PanelItem name="Time to segment ready" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.time_to_segment_ready || 0} />
              <PanelItem name="Time since load start" dataClassification={DataClassification.CustomerOnly} value={this.props.data.play_session_info.time_since_load_start || 0} />
            </Layout>
          </StyledLayout>
        </Layout>
        {errorList}
      </Layout>
    );
  }
}
