import * as React from 'react';
import { Route, Switch } from 'react-router-dom';
import { Layout } from 'twitch-core-ui';
import { SessionViewerHome } from './pages/home';
import { SessionDetailPage } from './pages/sessiondetail';
import { SessionList } from './pages/sessionlist';
import './styles.css';

export class SessionviewerPage extends React.Component<{}, {}> {
  public render() {
    return (
      <Layout fullHeight padding={3}>
        <Switch>
          <Route path="/sessionviewer" exact component={SessionViewerHome} />
          <Route path="/sessionviewer/:customer_id/:region/:content_id" exact component={SessionList} />
          <Route path="/sessionviewer/:customer_id/:region/:content_id/:session_id" exact component={SessionDetailPage} />
          <Route path="/sessionviewer/:customer_id/:region/:content_id/:master_session_id/:session_id" exact component={SessionDetailPage} />
        </Switch>
      </Layout>
    );
  }
}
