import * as React from 'react';
import { Route, Switch } from 'react-router-dom';
import { Layout } from 'twitch-core-ui';
import { CaptureEndpoint } from './pages/capture-endpoint';
import { CapturedFile } from './pages/captured-file';
import { VideoAnalysisHome } from './pages/home';
import { NewCaptureEndpoint } from './pages/new-capture-endpoint';
import { NewRTMPDump } from './pages/new-rtmp-dump';
import { RTMPDump } from './pages/rtmp-dump';
//import './styles.scss';

export class VideoAnalysisPage extends React.Component<{}, {}> {
  public render() {
    return (
      <Layout fullHeight padding={3}>
        <Switch>
          <Route path="/videoanalysis" exact component={VideoAnalysisHome} />
          <Route path="/videoanalysis/capture-endpoint/new" exact component={NewCaptureEndpoint} />
          <Route path="/videoanalysis/capture-endpoint/:endpoint_id" exact component={CaptureEndpoint} />
          <Route path="/videoanalysis/captured-file/:key*" exact component={CapturedFile} />
          <Route path="/videoanalysis/rtmp-dump/new" exact component={NewRTMPDump} />
          <Route path="/videoanalysis/rtmp-dump/:rtmp_dump_id" exact component={RTMPDump} />
        </Switch>
      </Layout>
    );
  }
}
