import * as React from 'react';
import { match, Redirect } from 'react-router-dom';
import { AppContext } from 'common/appcontext';
// @ts-ignore
import { AlignSelf, Button, ButtonType, CoreText, Display, FlexDirection, FormGroupOrientation, JustifyContent, Layout, LoadingSpinner, StyledLayout, SVGAsset, Table, TableBody, TableCell, TableHeader, TableHeading, TableRow, TextType } from 'twitch-core-ui';
import { CapturedFileAnalysis } from '../../components/captured-file';

interface URLParams {
  key: string;
}

interface Props {
  match: match<URLParams>;
}

export interface State {
  navigate: string | undefined;
  loading: boolean;
}

export class CapturedFile extends React.Component<Props, State> {
  public state: State = {
    navigate: undefined,
    loading: false,
  };

  public render() {
    if (this.state.navigate !== undefined) {
      return <Redirect to={this.state.navigate} push={true} />;
    }

    if (this.state.loading) {
      return <LoadingSpinner />;
    }

    return (
      <CapturedFileAnalysis file_path={this.props.match.params.key} />
    );
  }
}

CapturedFile.contextType = AppContext;
