(function ($) {
	"use strict";

	/*----------------------------
    Responsive menu Active
    ------------------------------ */
	$(".mainmenu ul#primary-menu").slicknav({
		allowParentLinks: true,
		prependTo: '.responsive-menu',
	});

	/*----------------------------
    START - Menubar scroll animation
    ------------------------------ */
	$(window).on('scroll', function () {
		if ($(this).scrollTop() > 70) {
			$('.header').addClass("sticky");
		} else {
			$('.header').removeClass("sticky");
		}
	});

	/*----------------------------
    START - Smooth scroll animation
    ------------------------------ */
	$('.header li a').on('click', function () {
		if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') &&
			location.hostname == this.hostname) {
			var $target = $(this.hash);
			$target = $target.length && $target ||
				$('[name=' + this.hash.slice(1) + ']');
			if ($target.length) {
				var targetOffset = $target.offset().top;
				$('html,body')
					.animate({
						scrollTop: targetOffset
					}, 2000);
				return false;
			}
		}
	});

	/*----------------------------
    START - Scroll to Top
    ------------------------------ */
	$(window).on('scroll', function () {
		if ($(this).scrollTop() > 1000) {
			$('.scrolltotop').fadeIn();
		} else {
			$('.scrolltotop').fadeOut();
		}
	});
	$('.scrolltotop').on('click', function () {
		$('html, body').animate({
			scrollTop: 0
		}, 2000);
		return false;
	});

	/*----------------------------
    START - Preloader
    ------------------------------ */
	$(window).on('load', function () {
		$('#preloader').fadeOut('slow', function () {
			$(this).remove();
		});
	});

	/*----------------------------
    START - WOW JS animation
    ------------------------------ */
	new WOW().init();

}(jQuery));