package aws

import (
	logging "code.justin.tv/event-engineering/golibs/pkg/logging"
	"code.justin.tv/event-engineering/streamtester/pkg/aws/backend"
	"github.com/aws/aws-sdk-go/service/ssm"
)

// New generates a new AWS Client with the supplied backend client
func New(awsClient backend.Client, logger logging.Logger) *Client {
	return &Client{
		aws:    awsClient,
		logger: logger,
	}
}

// Client is an AWS client containing methods for use in the goldengate system
type Client struct {
	aws    backend.Client
	logger logging.Logger
}

// SSMGetParameters calls the underlying SSMGetParameters from the aws backend
func (c *Client) SSMGetParameters(input *ssm.GetParametersInput) (*ssm.GetParametersOutput, error) {
	return c.aws.SSMGetParameters(input)
}
