package streamtesterAPI

import (
	rpc "code.justin.tv/event-engineering/streamtester/pkg/rpc"
	"code.justin.tv/video/lvsapi/rpc/lvs"
	"context"
	"fmt"
	"github.com/google/uuid"
	"net/http"
)

type Handler struct {
	Server    http.Handler
	lvsClient lvs.LiveVideoService
}

func New(certPem, keyPem, caPem []byte) (*Handler, error) {
	handler := &Handler{}
	httpClient, err := GetLVSHttpClient(certPem, keyPem, caPem)
	if err != nil {
		return nil, err
	}

	handler.Server = rpc.NewStreamTesterServer(handler, nil)
	handler.lvsClient = lvs.NewLiveVideoServiceProtobufClient("https://lvs-prod.twitch.tv", httpClient)

	return handler, nil
}

func (h *Handler) CreateStreamKey(context context.Context, req *rpc.CreateStreamKeyReq) (*rpc.CreateStreamKeyResp, error) {
	contentID := req.GetContentId()
	if contentID == "" {
		contentID = uuid.New().String()
	}

	fmt.Println("Create stream key for content ID " + req.GetContentId())

	resp, err := h.lvsClient.CreateStreamKey(context, &lvs.CreateStreamKeyRequest{
		ContentId:  contentID,
		TtlSeconds: 60,
	})

	if err != nil {
		fmt.Println("Error creating stream key ", err)
		return nil, err
	}

	return &rpc.CreateStreamKeyResp{
		StreamKey: resp.GetStreamkey() + "?bandwidthtest=true",
	}, nil
}
