package streamtesterAPI

import (
	"crypto/tls"
	"crypto/x509"
	"net/http"
)

func GetLVSHttpClient(certPem, keyPem, caPem []byte) (*http.Client, error) {
	// Load client cert
	cert, err := tls.X509KeyPair(certPem, keyPem)
	if err != nil {
		return nil, err
	}

	// Setup HTTPS client
	tlsConfig := &tls.Config{
		Certificates: []tls.Certificate{cert},
	}

	if caPem != nil {
		// Load CA cert
		caCertPool := x509.NewCertPool()
		caCertPool.AppendCertsFromPEM(caPem)
		tlsConfig.RootCAs = caCertPool
	}

	tlsConfig.BuildNameToCertificate()
	transport := &http.Transport{TLSClientConfig: tlsConfig}

	return &http.Client{Transport: transport}, nil
}
