# api-gateway-handler

Helper package to map an API Gateway proxy request in a lambda function to something that works with an http.Handler.

In my use case I'm using it to invoke a twirp service handler

## Usage (twirp example)
```
var myTwirpService myTwirpPackage.TwirpServer
var binaryContentTypes = []string{"application/protobuf"}

func main() {
  myTwirpService = myTwirpPackage.NewTwirpServiceServer(handler, nil)
  lambda.Start(Handle)
}

func Handle(ctx context.Context, request APIGatewayProxyRequest) (APIGatewayProxyResponse, error) {
  return apiGatewayHandler.ProcessRequest(ctx, request, binaryContentTypes, myTwirpService)
}
```
