package main

import (
	"flag"
	"log"

	rtmplog "code.justin.tv/event-engineering/gortmp/pkg/log"
	"code.justin.tv/event-engineering/gortmp/pkg/player"
	"code.justin.tv/event-engineering/gortmp/pkg/rtmp"
	goctx "context"
)

var rtmpURL = flag.String("rtmp", "", "rtmp connect url")
var test = flag.Bool("test", false, "just check if the stream is up")

type playerHandler struct{}

func (h *playerHandler) Handle(ctx goctx.Context, r rtmp.Receiver, msg rtmp.Message) error {
	switch msg := msg.(type) {
	case *rtmp.RawMessage:
		raw := *msg
		raw.Data = nil
		rtmplog.Infof(ctx, "Raw: %#v", raw)
	}
	return r.Handle(msg)
}

func testPlay(p *player.RtmpPlayer) bool {
	err := p.PlayRTMP(&playerHandler{})
	return err == nil
}

func main() {
	rtmplog.SetLogLevel(rtmplog.LogDebug)
	log.SetFlags(0)
	flag.Parse()
	rtmpPlayer, err := player.NewRtmpPlayer(*rtmpURL)
	if err != nil {
		log.Fatalf("Error connecting stream: %s", err)
	}
	if *test {
		ok := testPlay(rtmpPlayer)
		rtmpPlayer.Conn.Close()
		if ok {
			log.Println("Test result: OK")
		} else {
			log.Println("Test result: NOT OK")
		}
	} else {
		if err = rtmpPlayer.PlayRTMP(&playerHandler{}); err != nil {
			log.Fatalf("Error playing stream: %s", err)
		}
	}
}
