package flvdata

import (
	"bytes"
	"testing"

	"code.justin.tv/event-engineering/gortmp/pkg/flv"
)

func TestFlvFileReader(t *testing.T) {
	file, err := flv.OpenFile("./data/tiny.flv")
	if err != nil {
		t.Fatalf("error opening disk file %v", err)
	}
	bs := MustAsset("data/tiny.flv")
	memFile, err := flv.WrapInMemoryFile(bytes.NewReader(bs), "./data/tiny.flv")
	if err != nil {
		t.Fatalf("error opening memory file %v", err)
	}

	if file.Size() != memFile.Size() {
		t.Fatalf("file size mismatch %d vs %d", file.Size(), memFile.Size())
	}

	for tagNumber := 0; !file.IsFinished() && !memFile.IsFinished(); tagNumber++ {
		header1, data1, err := file.ReadTag()
		if err != nil {
			t.Fatal("error reading disk file:", err)
		}
		header2, data2, err := memFile.ReadTag()
		if err != nil {
			t.Fatal("error reading memory file:", err)
		}
		if *header1 != *header2 {
			t.Fatalf("header mismatch for tag number %d\n%+v\n%+v", tagNumber, header1, header2)
		}
		if !bytes.Equal(data1, data2) {
			t.Fatalf("data mismatch for tag number %d\n%+v\n%+v", tagNumber, data1, data2)
		}
	}

	if !file.IsFinished() {
		t.Fatal("disk file is not finished")
	}
	if !memFile.IsFinished() {
		t.Fatal("memory file is not finished")
	}
}
