package rtmp

import (
	"net"
)

type Receiver interface {
	Handle(Message) error
}

type Conn interface {
	Write(Message) error
	Close() error

	RemoteAddr() net.Addr
	LocalAddr() net.Addr
}

type Stream interface {
	Write(Message) error
	Conn() Conn
	ReleaseMediaStream() (MediaStream, error)
}
