package main

import (
	logging "code.justin.tv/event-engineering/golibs/pkg/logging"
	"fmt"
	"github.com/Sirupsen/logrus"
	"github.com/spf13/cobra"
	"os"
)

var rootCmd = &cobra.Command{
	Use:   "rtmp",
	Short: "rtmp utilities",
	Long:  `An assortment of RTMP utilities`,
	Run: func(cmd *cobra.Command, args []string) {
		fmt.Println("Available Commands")
		fmt.Println("dump --input --output")
		fmt.Println("tail --input --output --seconds")
	},
}

var logger logging.Logger

func init() {
	logger = logrus.New()
}

func main() {
	if err := rootCmd.Execute(); err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}
