package log

type NLogger interface {
	// Log a particular format string at most 'count' times
	Logf(level LogLevel, count int, format string, v ...interface{})
}

type nLogger struct {
	counts map[string]int
	log    Logger
}

// Make a concurrency UNSAFE NLogger
func NewNLogger(l Logger) *nLogger {
	return &nLogger{make(map[string]int), l}
}

func (n *nLogger) Logf(level LogLevel, count int, format string, v ...interface{}) {
	if n.counts[format] < count {
		n.counts[format]++
		n.log.Output(level, format, v...)
	}
}
