package player

import (
	"testing"

	"code.justin.tv/video/gortmp/pkg/rtmp"
)

func TestInvokeStatus(t *testing.T) {
	player := RtmpPlayer{
		URL:  nil,
		Conn: nil,
		tm:   NewTransactionMap(),
	}

	good := rtmp.OnStatusCommand{
		Info: rtmp.NetStreamPlayInfo{
			Status:  rtmp.StatusPlayStart("play"),
			Details: "details",
		},
	}

	err := player.Handle(testHelperRoundTripMessage(t, good))
	if err != nil {
		t.Fatal("good input, got error:", err)
	}

	bad := rtmp.OnStatusCommand{
		Info: rtmp.NetStreamPlayInfo{
			Status:  rtmp.StatusPlayStreamNotFound("not_found"),
			Details: "details",
		},
	}

	err = player.Handle(testHelperRoundTripMessage(t, bad))
	if err == nil {
		t.Fatal("bad input, got nil error")
	}
}

// the real player doesn't get nice hand crafted objects, it gets stuff that's
// been flattened over the wire
func testHelperRoundTripMessage(t *testing.T, msg rtmp.Message) rtmp.Message {
	raw, err := msg.RawMessage()
	if err != nil {
		t.Fatal(err)
	}
	outMsg, err := rtmp.ParseCommand(raw)
	if err != nil {
		t.Fatal(err)
	}
	return outMsg
}
