//
// +build ignore

package main

import (
	"bytes"
	"crypto/tls"
	"crypto/x509"
	"flag"
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
)

var (
	serverCert = flag.String("server-cert", "", "server public certificate")
	clientCert = flag.String("client-cert", "", "client certificate")
	clientKey  = flag.String("client-key", "", "client key")
	method     = flag.String("method", "GET", "request method")
	body       = flag.String("body", "", "request body")
	urlStr     = flag.String("url", "", "request url")
)

func main() {
	log.SetFlags(0)
	flag.Parse()

	// Load client cert
	cert, err := tls.LoadX509KeyPair(*clientCert, *clientKey)
	if err != nil {
		log.Fatal("Failed to load client key pair: ", err)
	}

	var certPool *x509.CertPool

	if *serverCert != "" {
		// Load CA cert
		caCert, err := ioutil.ReadFile(*serverCert)
		if err != nil {
			log.Fatal("Failed to read server cert: ", err)
		}
		certPool = x509.NewCertPool()
		certPool.AppendCertsFromPEM(caCert)
	}

	// Setup HTTPS client
	tlsConfig := &tls.Config{
		Certificates: []tls.Certificate{cert},
		RootCAs:      certPool,
	}
	tlsConfig.BuildNameToCertificate()
	transport := &http.Transport{TLSClientConfig: tlsConfig}
	client := &http.Client{Transport: transport}

	req, err := http.NewRequest(*method, *urlStr, bytes.NewReader([]byte(*body)))
	resp, err := client.Do(req)
	if err != nil {
		log.Fatal("HTTP Request error: ", err)
	}
	contents, err := ioutil.ReadAll(resp.Body)
	fmt.Printf("%s\n", string(contents))
}
